<?php $__env->startSection('panel'); ?>

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.services.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="category_id" class="font-weight-bold"><?php echo app('translator')->get('Category Name'); ?></label>
                                <select class="form-control" name="category_id" id="category_id" required="">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <option value="<?php echo e($category->id); ?>"><?php echo e(__($category->name)); ?></option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Service Name'); ?></label>
                                <input type="text" name="name" id="name" value="<?php echo e(old('name')); ?>"
                                    class="form-control" placeholder="<?php echo app('translator')->get('Name'); ?>"
                                    required>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="price" class="font-weight-bold"><?php echo app('translator')->get('Price per 1k'); ?></label>
                                <input type="number" name="price" id="price" value="<?php echo e(old('price')); ?>"
                                    class="form-control" placeholder="<?php echo app('translator')->get('Price'); ?>"
                                    required>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="min" class="font-weight-bold"><?php echo app('translator')->get('Min'); ?></label>
                                <input type="number" name="min" id="min" value="<?php echo e(old('min')); ?>"
                                    class="form-control" placeholder="<?php echo app('translator')->get('Min'); ?>"
                                    required>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="max" class="font-weight-bold"><?php echo app('translator')->get('Max'); ?></label>
                                <input type="number" name="max" id="max" value="<?php echo e(old('max')); ?>"
                                    class="form-control" placeholder="<?php echo app('translator')->get('Max'); ?>"
                                    required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="type" class="font-weight-bold"><?php echo app('translator')->get('Status'); ?></label>
                                <select name="status" id="status" class="form-control">
                                   <option value="1"><?php echo app('translator')->get('Active'); ?></option>
                                   <option value="0"><?php echo app('translator')->get('Deactive'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="details" class="font-weight-bold "><?php echo app('translator')->get('Details'); ?></label>
                                <textarea name="details" class="form-control" id="details" cols="30" rows="10" placeholder="<?php echo app('translator')->get('Details'); ?>"></textarea>
                            </div>
                        </div>

                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end ">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> <?php echo app('translator')->get('Create'); ?></button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.services.index')); ?>" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i><?php echo app('translator')->get('Go Back'); ?></a>


        <button class="btn btn--primary box--shadow1 text--small" id="actionButton" data-bs-toggle="dropdown">
            <?php echo app('translator')->get('Add API Services'); ?>
            <i class="las la-cloud-upload-alt"></i>
        </button>
        <div class="dropdown-menu p-0">
            <?php $__currentLoopData = $apiLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apiList): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('admin.services.api', $apiList->id)); ?>" class="dropdown-item">
                    <i class="las la-cloud-download-alt"></i>
                    <?php echo e(__($apiList->name)); ?>

                </a>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smm\application\resources\views/admin/services/create.blade.php ENDPATH**/ ?>